#!/bin/sh

TP_RADIOLIST_RESULT_STATIC="$DTAS[TUI]@{STATIC}"
TP_RADIOLIST_RESULT_DHCP="$DTAS[TUI]@{DHCP}"
TP_RADIOLIST_RESULT_NULL="DTAS[TUI]@{NULL}"
TP_RADIOLIST_RESULT_SELECT=""

TP_RADIOLIST_RESULT_OK="DTAS[TUI]@{OK}"
TP_RADIOLIST_RESULT_CANCEL="DTAS[TUI]@{CANCEL}"
TP_RADIOLIST_RESULT_ERROR="DTAS[TUI]@{ERROR}"
TP_RADIOLIST_RESULT_CODE=""

TP_RADIOLIST_RESULT_MSG=""

tp_radiolist() {
	debug_print "${0}" "${LINENO}" 'in function "tp_radiolist"'

	local title="${1}"
	local text="${2}"
	local label_ok="${3}"
	local label_cancel="${4}"
	local radio_list="${5}"
	local radio_number="${6:-0}"
	
    exec 3>&1
    local ret=`sh -c "dialog \
        --backtitle    \"${CONS_BACK_TITLE}\" \
        --title        \"${title}\" \
        --ok-label     \"${label_ok}\" \
        --cancel-label \"${label_cancel}\" \
        --radiolist    \"${text}\" \
                       \"${CONS_BOX_HEIGHT}\" \
                       \"${CONS_BOX_WIDTH}\" \
                       ${radio_number} \
                       ${radio_list} \
        2>&1 1>&3"; \
        case "${?}" in \
            1|255) echo "${TP_RADIOLIST_RESULT_CANCEL}" ; return ;;
        esac`
    exec 3>&-
    
    debug_print "${0}" "${LINENO}" "Ret: ${ret}"
    case "${ret}" in
        # press CANCEL or ESC
        "${TP_RADIOLIST_RESULT_CANCEL}") 
            TP_RADIOLIST_RESULT_CODE="${TP_RADIOLIST_RESULT_CANCEL}"
            TP_RADIOLIST_RESULT_SELECT="${TP_RADIOLIST_RESULT_NULL}"
            TP_RADIOLIST_RESULT_MSG=""
            ;;
        *)
			TP_RADIOLIST_RESULT_CODE="${TP_RADIOLIST_RESULT_OK}"
			TP_RADIOLIST_RESULT_SELECT="${ret}"
			TP_RADIOLIST_RESULT_MSG=""
			;;
    esac
}
